﻿uses MathExtensions;

 
// ЕСТЬ ЛИ В СТРОКЕ ПОВТОРЯЮЩИЕСЯ ЦИФРЫ
function Check(s: string): bool;
begin
   var distinctChars := s.Distinct().ToList();
   Result := distinctChars.Count <> s.Length;
end;

// ЕСТЬ ЛИ В СТРОКЕ НУЛЬ ИЛИ ПОВТОРЯЮЩИЕСЯ ЦИФРЫ
function Check0(s: string) := s.Contains('0') or Check(s);


// РЕКУРСИВНАЯ ФУНКЦИЯ - ИЩЕТ КОМБИНАЦИИ КВАДРАТОВ ДЛЯ ЗАДАННОГО НАБОРА ЦИФР
procedure Find(digits: HashSet<char>; 
               sqs: List<int64>; 
               i: integer; 
               squares: List<string>; 
               var minSum: int64);
begin
   // все цифры имеются — обновляем минимум:
   if digits.Count = 0 then begin
      var sum := sqs.Sum();
      if (minSum = 0) or (sum < minSum) then begin
          minSum := sum;
          var s := string.Join(', ', sqs);
          Writeln($' {s} => {sum}');
      end;
      exit;
   end;

   // перебираем квадраты, начиная с индекса i:
   for var j := i to squares.Count - 1 do begin
       var sq := squares[j];

       // если длина квадрата больше, 
       // чем осталось цифр, то дальше не ищем
       if sq.Length > digits.Count then break;

       // gроверяем, что все цифры квадрата содержатся в оставшихся цифрах:
       if not sq.All(digits.Contains) then continue;

       // hекурсивно продолжаем поиск, убрав использованные цифры:
       var remainingDigits := new HashSet<char>(digits.Except(sq.ToCharArray()));
       var newSqs := new List<int64>(sqs);
       newSqs.Add(StrToInt64(sq));
       Find(remainingDigits, newSqs, j + 1, squares, minSum);
    end;
end;

  
// РЕШАЕМ ЗАДАЧУ
procedure Solve(n: int64; check: Func<string, boolean>);
begin
   var minSum: int64:= 0;
   Writeln($' Решение для n = {n}');

   // cобираем в список все квадраты <= n, 
   // удовлетворяющие условию check
   var squares := new List<string>();
   var i: int64 := 1;
   while true do begin
      var sq: int64 := i * i;
      if sq > n then break;

      var s := sq.ToString();
      if check(s) then begin
         i += 1;
         continue;
      end;

      squares.Add(s);
      i += 1;
   end;

   // заданные цифры:
   var targetDigits := new HashSet<char>(n.ToString().ToCharArray());
   minSum := 0;

   // решаем задачу:
   Find(targetDigits, new List<int64>(), 0, squares, minSum);

   // печатаем ответ
   if minSum <> 0 then
      Writeln($' min({n}) = {minSum}')
   else
      Writeln($' min({n}) = не найдено');
   Writeln;
end;


begin
   Writeln(' Enigma 1518: Sets of squares');
   Writeln;
  
  // Без нулей и без повторов
  Solve(987654321, Check0);
  
  // С нулями и без повторов
  Solve(9876543210, Check);
end.
